//
//  MCPDefinitionObject.h
//  MCPersistence
//
//  Created by aj on Fri Dec 21 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

/*
Just a convienient superclass. Meant to be subclassed where subclasses have specific methods name that poke into the property list. Meant to be read only

*/


@interface MCPDefinitionObject : NSObject {

	id				 _propertyList;
	NSMutableArray  *_editableInfo;

}

- (id)initWithSerializedData:(NSData *)aData;
- (id)initWithContentsOfFile:(NSString *)fullpath;
- (id)initWithDictionary:(NSMutableDictionary *)dictionary;


- (void)setPropertyList:(id)plist;
- (id)propertyList;

- (id)userInfo;

// Subclasses can do special stuff if needed. Called after the ivar is set
- (void)didSetPropertyList;

- (NSMutableArray* )editableUserInfo;
- (NSDictionary*)setEditableUserInfo;
- (NSMutableDictionary *)createAndAddUserInfo;
- (void)removeUserInfo:(NSDictionary *)aUserInfo;



@end
